<?php
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$studentId = isset($_GET['student_id']) ? $_GET['student_id'] : "12032810611";
$qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode("https://result.bouedu.org/hsc_document.php?student_id=" . $studentId);
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $qrUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$qrImageData = curl_exec($ch);
curl_close($ch);

$qrBase64 = $qrImageData ? 'data:image/png;base64,' . base64_encode($qrImageData) : '';


ob_start();

include("conn.php");

$studentSQL = mysqli_query($conn,"SELECT * FROM `student` WHERE `student_id`='$studentId'");
$studentData = mysqli_fetch_assoc($studentSQL);
$resultSQL = mysqli_query($conn,"SELECT * FROM `hsc` WHERE `student_id`= '$studentId'");
$studentResultRaw = mysqli_fetch_assoc($resultSQL);

$groupe = $studentResultRaw['groupe'];



 function resultCalculate($result){
     
     if ($result > 79) {
                $grade_point = "A+";
                $point = 5.00;
            } elseif ($result > 69) {
                $grade_point = "A";
                $point = 4.00;
            } elseif ($result > 59) {
                $grade_point = "A-";
                $point = 3.50;
            } elseif ($result > 49) {
                $grade_point = "B";
                $point = 3.00;
            } elseif ($result > 39) {
                $grade_point = "C";
                $point = 2.00;
            } elseif ($result > 32) {
                $grade_point = "D";
                $point = 1.00;
            } else {
                $grade_point = "F";
                $point = 0.00;
            }
            
            return [
                     'grade_point' => $grade_point,
                     'point' => $point
                   ];

 }
 
 $bangla = $studentResultRaw['Bangla_1'];
$banglaRes = resultCalculate($bangla);

$bangla2 = $studentResultRaw['Bangla_2'];
$bangla2Res = resultCalculate($bangla2);

$english1 = $studentResultRaw['English_1'];
$english1Res = resultCalculate($english1);

$english2 = $studentResultRaw['English_2'];
$english2Res = resultCalculate($english2);

$ict = $studentResultRaw['ict'];
$ictRes = resultCalculate($ict);

$civics1 = $studentResultRaw['Civics1'];
$civics1Res = resultCalculate($civics1);

$civics2 = $studentResultRaw['Civics2'];
$civics2Res = resultCalculate($civics2);

$economics1 = $studentResultRaw['Economics1'];
$economics1Res = resultCalculate($economics1);

$economics2 = $studentResultRaw['Economics2'];
$economics2Res = resultCalculate($economics2);

$islamic1 = $studentResultRaw['agriculture1'];
$islamic1Res = resultCalculate($islamic1);

$islamic2 = $studentResultRaw['agriculture2'];
$islamic2Res = resultCalculate($islamic2);

$islamic_history1 = $studentResultRaw['islamic_history1'];
$islamic_history1Res = resultCalculate($islamic_history1);

$islamic_history2 = $studentResultRaw['islamic_history2'];
$islamic_history2Res = resultCalculate($islamic_history2);





   $passingYear = $studentResultRaw['exam_year'];


 
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Academic Transcript</title>
  <style>
    body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
    .container { width: 100%; max-width: 750px; margin: 0 auto; padding: 16px; }
    .header-table { width: 100%; table-layout: fixed; }
    .header-table td { vertical-align: middle; text-align: center; }
    .header-table .logo { width: 20%; text-align: left; }
    .header-table .title { width: 60%; padding: 0 10px; }
    .header-table .qr { width: 20%; text-align: right; }
    .text-sm { font-size: 14px; font-weight: 600; color: #374151; }
    .text-lg { font-size: 18px; font-weight: bold; }
    .text-xs { font-size: 12px; }
    .border { border: 1px solid #d1d5db; border-collapse: collapse; }
    .border td, .border th { border: 1px solid #d1d5db; padding: 4px; }
    .mt-20 { margin-top: 80px; }
    .mt-3 { margin-top: 12px; }
    .mb-4 { margin-bottom: 16px; }
    .year-results-block { margin-top: 1rem; }
    .year-results-block h2 { text-align: center; font-weight: 700; font-size: 1rem; margin: 0; color: #111827; }
    .year-table-wrapper { border: 1px solid #d1d5db; }
    .custom-table { width: 100%; border-collapse: collapse; font-size: 0.75rem; }
    .custom-table td, .custom-table th { padding: 1px 2px; color: #000000; font-weight: 500; }
    .year-table thead tr { border-bottom: 1px solid #d1d5db; }
    .year-table th { border-right: 1px solid #d1d5db; text-align: center; font-weight: 600; padding: 5px 3px; }
    .year-table th:last-child { border-right: none; }
    .year-table tbody tr.bordered-row td { border-bottom: 1px solid #d1d5db; }
    .year-table tbody td { border-right: 1px solid #d1d5db; text-align: center; }
    .year-table tbody td:last-child { border-right: none; }
    .subject-name-cell { padding-left: 0.5rem; text-align: left; }
    
    h1, p {
  margin: 0;
  padding: 0;
  line-height: 1.2;
}

.year-table tbody td.subject-name-cell {
  text-align: left !important;
}


  </style>
</head>
<body>
<div class="container">
  <table class="header-table">
    <tr>
      <td class="logo">
        <img src="https://result.bouedu.org/images_doc/gray-logo.png" alt="Logo" width="80">
      </td>
      <td class="title">
        <h1 class="text-lg">Bangladesh Open University</h1>
        <p class="text-sm">Higher Secondary Certificate</p>
        <p class="text-sm">ACADEMIC RECORD (Online Version)</p>
      </td>
      <td class="qr">
        <img src="<?= $qrBase64 ?>" width="80" height="80" alt="QR Code">
      </td>
    </tr>
  </table>

  <div class="mt-3 mb-4" style="border-top: 1px solid #ccc;"></div>

  <table class="border text-xs" width="100%">
    <tr><td width="30%">Student ID:</td><td><?= $studentData['student_id'];?></td></tr>
    <tr><td>Student Name:</td><td><?= $studentData['name'];?></td></tr>
    <tr><td>Father's Name:</td><td><?= $studentData['father_name'];?></td></tr>
    <tr><td>Mother's Name:</td><td><?= $studentData['mother_name'];?></td></tr>
    <tr><td>Date of Birth:</td><td><?= $studentData['birth'];?></td></tr>
    <tr><td>Academic Year/Batch:</td><td><?= $studentData['batch'];?></td></tr>
    <tr><td>Passing Year:</td><td><?= $passingYear;?></td></tr>
    <tr><td>Result:</td><td><?= $studentResultRaw['gpa'];?></td></tr>
    <tr><td>Study Center:</td><td><?=  $studentResultRaw['study_centre'];?></td></tr>
  </table>

  <div class="year-results-block">
    <h2>1st Year</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course CODE</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC101</td><td class="subject-name-cell">Bangla 1st Paper</td><td><?php echo $banglaRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC107</td><td class="subject-name-cell">English 1st Paper</td><td><?php echo $english1Res['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC285</td><td class="subject-name-cell">Information and Communication Technology</td><td><?php echo $ictRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC269</td><td class="subject-name-cell">Civics and Good Governance 1st Paper</td><td><?php echo $civics1Res['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC109</td><td class="subject-name-cell">Economics 1st Paper</td><td><?php echo $economics1Res['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear; ?></td><td>HSC249</td><td class="subject-name-cell">Agriculture 1st Paper</td><td><?php echo $islamic1Res['grade_point']; ?></td></tr>
          
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="year-results-block">
    <h2>2nd Year</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>HSC102</td><td class="subject-name-cell">Bangla 2nd Paper</td><td><?php echo $bangla2Res['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>HSC108</td><td class="subject-name-cell">Engilsh 2nd Paper</td><td><?php echo $english2Res['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>HSC270</td><td class="subject-name-cell">Civics and Good Governance 2nd Paper</td><td><?php echo $civics2Res['grade_point']; ?></td></tr>
          
         
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>HSC110</td><td class="subject-name-cell">Economics 2nd Paper</td><td><?php echo $economics2Res['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>HSC250</td><td class="subject-name-cell">Agriculture 2nd Paper</td><td><?php echo $islamic2Res['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-3 text-xs border" style="padding: 6px;">
    <p><strong>Note 1:</strong> (-) - Waiver AB - Absent, PR - Problem Related to OMR Sheet fill-up, RP - Expelled in the respective course, WH - Withheld, IC - Incomplete, NA - Not Applicable, X - No Grade Received.</p>
    <p><strong>Note 2:</strong> This report is system generated. No signature required.</p>
  </div>

  <div class="mt-20" style="border-top: 1px solid #ccc;"></div>
  <p class="text-xs text-center" style="margin-top: 4px;">
    All Rights Reserved by BOU. Developed & Maintained by ICT Unit, BOU
  </p>
</div>
</body>
</html>
<?php
$html = ob_get_clean();
$dompdf = new Dompdf();
$dompdf->set_option('isRemoteEnabled', true);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Academic Transcript.pdf", ["Attachment" => false]);
exit;
?>
