<?php
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$studentId = isset($_GET['student_id']) ? $_GET['student_id'] : "12032810611";
$qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode("https://result.bouedu.org/document.php?student_id=" . $studentId);

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $qrUrl);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
curl_setopt($ch, CURLOPT_TIMEOUT, 10);
$qrImageData = curl_exec($ch);
curl_close($ch);

$qrBase64 = $qrImageData ? 'data:image/png;base64,' . base64_encode($qrImageData) : '';


ob_start();

include("conn.php");

$studentSQL = mysqli_query($conn,"SELECT * FROM `student` WHERE `student_id`='$studentId'");
$studentData = mysqli_fetch_assoc($studentSQL);
$resultSQL = mysqli_query($conn,"SELECT * FROM `ssc` WHERE `student_id`= '$studentId'");
$studentResultRaw = mysqli_fetch_assoc($resultSQL);

$groupe = $studentResultRaw['groupe'];



 function resultCalculate($result){
     
     if ($result > 79) {
                $grade_point = "A+";
                $point = 5.00;
            } elseif ($result > 69) {
                $grade_point = "A";
                $point = 4.00;
            } elseif ($result > 59) {
                $grade_point = "A-";
                $point = 3.50;
            } elseif ($result > 49) {
                $grade_point = "B";
                $point = 3.00;
            } elseif ($result > 39) {
                $grade_point = "C";
                $point = 2.00;
            } elseif ($result > 32) {
                $grade_point = "D";
                $point = 1.00;
            } else {
                $grade_point = "F";
                $point = 0.00;
            }
            
            return [
                     'grade_point' => $grade_point,
                     'point' => $point
                   ];

 }
 
 $bangla = $studentResultRaw['bangla'];
$banglaRes = resultCalculate($bangla);

$banglatwo = $studentResultRaw['banglatwo'];
$banglatwoRes = resultCalculate($banglatwo);

$english = $studentResultRaw['english'];
$englishRes = resultCalculate($english);

$englishtwo = $studentResultRaw['englishtwo'];
$englishtwoRes = resultCalculate($englishtwo);

$math = $studentResultRaw['math'];
$mathRes = resultCalculate($math);

$baobi = $studentResultRaw['baobi'];
$baobiRes = resultCalculate($baobi);

$ict = $studentResultRaw['ict'];
$ictRes = resultCalculate($ict);

$ismal_and_mural = $studentResultRaw['ismal_and_mural'];
$ismal_and_muralRes = resultCalculate($ismal_and_mural);

$GEOGRAPHY_AND_ENVIRONMENT = $studentResultRaw['GEOGRAPHY_AND_ENVIRONMENT'];
$GEOGRAPHY_AND_ENVIRONMENTRes = resultCalculate($GEOGRAPHY_AND_ENVIRONMENT);

$Civics_and_Good_Governance = $studentResultRaw['Civics_and_Good_Governance'];
$Civics_and_Good_GovernanceRes = resultCalculate($Civics_and_Good_Governance);

$science = $studentResultRaw['science'];
$scienceRes = resultCalculate($science);

$econnomics = $studentResultRaw['econnomics'];
$econnomicsRes = resultCalculate($econnomics);




$Physics = $studentResultRaw['Physics'];
$PhysicsRes = resultCalculate($Physics);

$Chemistry = $studentResultRaw['Chemistry'];
$ChemistryRes = resultCalculate($Chemistry);

$Biology = $studentResultRaw['Biology'];
$BiologyRes = resultCalculate($Biology);

$Higher_Mathematics = $studentResultRaw['Higher_Mathematics'];
$Higher_MathematicsRes = resultCalculate($Higher_Mathematics);


$agriculture = $studentResultRaw['agriculture'];
$agricultureRes = resultCalculate($agriculture);


$Civics_and_citezenship = $studentResultRaw['Civics_and_citezenship'];
$Civics_and_citezenshipRes = resultCalculate($Civics_and_citezenship);

$history_of_bangladesh = $studentResultRaw['history_of_bangladesh'];
$history_of_bangladeshRes = resultCalculate($history_of_bangladesh);


   $passingYear = $studentResultRaw['exam_year'];
   
   $firstYear = $passingYear - 1;

 
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Academic Transcript</title>
  <style>
    body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
    .container { width: 100%; max-width: 750px; margin: 0 auto; padding: 16px; }
    .header-table { width: 100%; table-layout: fixed; }
    .header-table td { vertical-align: middle; text-align: center; }
    .header-table .logo { width: 20%; text-align: left; }
    .header-table .title { width: 60%; padding: 0 10px; }
    .header-table .qr { width: 20%; text-align: right; }
    .text-sm { font-size: 14px; font-weight: 600; color: #374151; }
    .text-lg { font-size: 18px; font-weight: bold; }
    .text-xs { font-size: 12px; }
    .border { border: 1px solid #d1d5db; border-collapse: collapse; }
    .border td, .border th { border: 1px solid #d1d5db; padding: 4px; }
    .mt-20 { margin-top: 80px; }
    .mt-3 { margin-top: 12px; }
    .mb-4 { margin-bottom: 16px; }
    .year-results-block { margin-top: 1rem; }
    .year-results-block h2 { text-align: center; font-weight: 700; font-size: 1rem; margin: 0; color: #111827; }
    .year-table-wrapper { border: 1px solid #d1d5db; }
    .custom-table { width: 100%; border-collapse: collapse; font-size: 0.75rem; }
    .custom-table td, .custom-table th { padding: 1px 2px; color: #000000; font-weight: 500; }
    .year-table thead tr { border-bottom: 1px solid #d1d5db; }
    .year-table th { border-right: 1px solid #d1d5db; text-align: center; font-weight: 600; padding: 5px 3px; }
    .year-table th:last-child { border-right: none; }
    .year-table tbody tr.bordered-row td { border-bottom: 1px solid #d1d5db; }
    .year-table tbody td { border-right: 1px solid #d1d5db; text-align: center; }
    .year-table tbody td:last-child { border-right: none; }
    .subject-name-cell { padding-left: 0.5rem; text-align: left; }
    
    h1, p {
  margin: 0;
  padding: 0;
  line-height: 1.2;
}

.year-table tbody td.subject-name-cell {
  text-align: left !important;
}


  </style>
</head>
<body>
<div class="container">
  <table class="header-table">
    <tr>
      <td class="logo">
        <img src="https://result.bouedu.org/images_doc/gray-logo.png" alt="Logo" width="80">
      </td>
      <td class="title">
        <h1 class="text-lg">Bangladesh Open University</h1>
        <p class="text-sm">Secondary School Certificate</p>
        <p class="text-sm">ACADEMIC RECORD (Online Version)</p>
      </td>
      <td class="qr">
        <img src="<?= $qrBase64 ?>" width="80" height="80" alt="QR Code">
      </td>
    </tr>
  </table>

  <div class="mt-3 mb-4" style="border-top: 1px solid #ccc;"></div>

  <table class="border text-xs" width="100%">
    <tr><td width="30%">Student ID:</td><td><?= $studentData['student_id'];?></td></tr>
    <tr><td>Student Name:</td><td><?= $studentData['name'];?></td></tr>
    <tr><td>Father's Name:</td><td><?= $studentData['father_name'];?></td></tr>
    <tr><td>Mother's Name:</td><td><?= $studentData['mother_name'];?></td></tr>
    <tr><td>Date of Birth:</td><td><?= $studentData['birth'];?></td></tr>
    <tr><td>Academic Year/Batch:</td><td><?= $studentData['batch'];?></td></tr>
    <tr><td>Passing Year:</td><td><?= $passingYear;?></td></tr>
    <tr><td>Result:</td><td><?= $studentResultRaw['totalgpa'];?></td></tr>
    <tr><td>Study Center:</td><td><?=  $studentResultRaw['study_centre'];?></td></tr>
  </table>

  <div class="year-results-block">
    <h2>1st Year</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course CODE</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1651</td><td class="subject-name-cell">Bangla 1st Paper</td><td><?php echo $banglaRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1652</td><td class="subject-name-cell">English 1st Paper</td><td><?php echo $englishRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1653</td><td class="subject-name-cell">Mathematics</td><td><?php echo $mathRes['grade_point']; ?></td></tr>
          <?php
          if($groupe == "science"){
          ?>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1370</td><td class="subject-name-cell">Information and Communication Technology</td><td><?php echo $ictRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1137</td><td class="subject-name-cell">Chemistry</td><td><?php echo $ChemistryRes['grade_point']; ?></td></tr>
          <?php
          }else if($groupe == "Humanities"){
              ?>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1370</td><td class="subject-name-cell">History of Bangladesh and World Civilization</td><td><?php echo $history_of_bangladeshRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $firstYear; ?></td><td>SSC1137</td><td class="subject-name-cell">Geography and Environment</td><td><?php echo $GEOGRAPHY_AND_ENVIRONMENTRes['grade_point']; ?></td></tr>
          <?php
          }
          ?>
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="year-results-block">
    <h2>2nd Year</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC2651</td><td class="subject-name-cell">Bangla 2nd Paper</td><td><?php echo $banglatwoRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC2652</td><td class="subject-name-cell">Engilsh 2nd Paper</td><td><?php echo $englishtwoRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC1656</td><td class="subject-name-cell">Hindu and Moral Education</td><td><?php echo $ismal_and_muralRes['grade_point']; ?></td></tr>
          <?php
           if($groupe == "science"){
           ?>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC1136</td><td class="subject-name-cell">Physics</td><td><?php echo $PhysicsRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC2138</td><td class="subject-name-cell">Biology</td><td><?php echo $BiologyRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC2126</td><td class="subject-name-cell">Higher Mathematics</td><td><?php echo $Higher_MathematicsRes['grade_point']; ?></td></tr>
          <?php
           }else if($groupe == "Humanities"){
               ?>
               <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC1660</td><td class="subject-name-cell">Bangladesh and Global Studies (BGS)</td><td><?php echo $mathRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC2673</td><td class="subject-name-cell">Civics and Citizenship</td><td><?php echo $Civics_and_citezenshipRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>SSC7358</td><td class="subject-name-cell">Agriculture Studies</td><td><?php echo $agricultureRes['grade_point']; ?></td></tr>
               <?php
           }
          ?>
          
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-3 text-xs border" style="padding: 6px;">
    <p><strong>Note 1:</strong> (-) - Waiver AB - Absent, PR - Problem Related to OMR Sheet fill-up, RP - Expelled in the respective course, WH - Withheld, IC - Incomplete, NA - Not Applicable, X - No Grade Received.</p>
    <p><strong>Note 2:</strong> This report is system generated. No signature required.</p>
  </div>

  <div class="mt-20" style="border-top: 1px solid #ccc;"></div>
  <p class="text-xs text-center" style="margin-top: 4px;">
    All Rights Reserved by BOU. Developed & Maintained by ICT Unit, BOU
  </p>
</div>
</body>
</html>
<?php
$html = ob_get_clean();
$dompdf = new Dompdf();
$dompdf->set_option('isRemoteEnabled', true);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Academic Transcript.pdf", ["Attachment" => false]);
exit;
?>
