<?php
require 'vendor/autoload.php';
use Dompdf\Dompdf;

$studentId = isset($_GET['student_id']) ? $_GET['student_id'] : "12032810611";
$qrUrl = "https://api.qrserver.com/v1/create-qr-code/?size=150x150&data=" . urlencode("https://result.bouedu.org/document.php?student_id=" . $studentId);
$qrImageData = @file_get_contents($qrUrl);
$qrBase64 = $qrImageData ? 'data:image/png;base64,' . base64_encode($qrImageData) : '';

ob_start();

include("conn.php");

$studentSQL = mysqli_query($conn,"SELECT * FROM `student` WHERE `student_id`='$studentId'");
$studentData = mysqli_fetch_assoc($studentSQL);
$resultSQL = mysqli_query($conn,"SELECT * FROM `bba` WHERE `student_id`= '$studentId'");
$studentResultRaw = mysqli_fetch_assoc($resultSQL);

$passingYear = $studentResultRaw['exam_year'];

 $thirtYear = $passingYear - 1;
 $secYear = $passingYear - 2;
 $fstYear = $passingYear - 3;

 function resultCalculate($result){
     
     if ($result > 79) {
                $grade_point = "A+";
                $point = 5.00;
            } elseif ($result > 69) {
                $grade_point = "A";
                $point = 4.00;
            } elseif ($result > 59) {
                $grade_point = "A-";
                $point = 3.50;
            } elseif ($result > 49) {
                $grade_point = "B";
                $point = 3.00;
            } elseif ($result > 39) {
                $grade_point = "C";
                $point = 2.00;
            } elseif ($result > 32) {
                $grade_point = "D";
                $point = 1.00;
            } else {
                $grade_point = "F";
                $point = 0.00;
            }
            
            return [
                     'grade_point' => $grade_point,
                     'point' => $point
                   ];

 }
 
$Intro_Business = $studentResultRaw['Intro_Business'];
$Intro_BusinessRes = resultCalculate($Intro_Business);

$GEnglish = $studentResultRaw['GEnglish'];
$GEnglishRes = resultCalculate($GEnglish);

$Busi_Comp_Studie = $studentResultRaw['Busi_Comp_Studie'];
$Busi_Comp_StudieRes = resultCalculate($Busi_Comp_Studie);

$Princ_Account = $studentResultRaw['Princ_Account'];
$Princ_AccountRes = resultCalculate($Princ_Account);

$ManagTheo_Prac = $studentResultRaw['ManagTheo_Prac'];
$ManagTheo_PracRes = resultCalculate($ManagTheo_Prac);

$bd_study = $studentResultRaw['bd_study'];
$bd_studyRes = resultCalculate($bd_study);

$Math_ManagDec = $studentResultRaw['Math_ManagDec'];
$Math_ManagDecRes = resultCalculate($Math_ManagDec);

$Bank_Management = $studentResultRaw['Bank_Management'];
$Bank_ManagementRes = resultCalculate($Bank_Management);

$Prin_Mark = $studentResultRaw['Prin_Mark'];
$Prin_MarkRes = resultCalculate($Prin_Mark);

$Advan_Account = $studentResultRaw['Advan_Account'];
$Advan_AccountRes = resultCalculate($Advan_Account);

$Fina_Manag = $studentResultRaw['Fina_Manag'];
$Fina_ManagRes = resultCalculate($Fina_Manag);

$Microeconomics = $studentResultRaw['Microeconomics'];
$MicroeconomicsRes = resultCalculate($Microeconomics);

$Business_Statistics = $studentResultRaw['Business_Statistics'];
$Business_StatisticsRes = resultCalculate($Business_Statistics);

$Environmental_Science = $studentResultRaw['Environmental_Science'];
$Environmental_ScienceRes = resultCalculate($Environmental_Science);

$Indus_Pshy = $studentResultRaw['Indus_Pshy'];
$Indus_PshyRes = resultCalculate($Indus_Pshy);

$Busi_Communi = $studentResultRaw['Busi_Communi'];
$Busi_CommuniRes = resultCalculate($Busi_Communi);

$Taxa_Aud = $studentResultRaw['Taxa_Aud'];
$Taxa_AudRes = resultCalculate($Taxa_Aud);

$Human_Res_Manag = $studentResultRaw['Human-Res_Manag'];
$Human_Res_ManagRes = resultCalculate($Human_Res_Manag);

$M_Management = $studentResultRaw['M_Management'];
$M_ManagementRes = resultCalculate($M_Management);

$Entrep_Develop = $studentResultRaw['Entrep_Develop'];
$Entrep_DevelopRes = resultCalculate($Entrep_Develop);

$Macroeconomics = $studentResultRaw['Macroeconomics'];
$MacroeconomicsRes = resultCalculate($Macroeconomics);

$Manage_Info_Syst = $studentResultRaw['Manage_Info_Syst'];
$Manage_Info_SystRes = resultCalculate($Manage_Info_Syst);

$E_Commerce = $studentResultRaw['E-Commerce'];
$E_CommerceRes = resultCalculate($E_Commerce);

$Mark_Prom = $studentResultRaw['Mark_Prom'];
$Mark_PromRes = resultCalculate($Mark_Prom);

$indus_Relation = $studentResultRaw['indus_Relation'];
$indus_RelationRes = resultCalculate($indus_Relation);

$Cost_Mana_Account = $studentResultRaw['Cost_Mana_Account'];
$Cost_Mana_AccountRes = resultCalculate($Cost_Mana_Account);

$Total_Qual_Manage = $studentResultRaw['Total_Qual_Manage'];
$Total_Qual_ManageRes = resultCalculate($Total_Qual_Manage);

$org_Behavior = $studentResultRaw['org_Behavior'];
$org_BehaviorRes = resultCalculate($org_Behavior);

$Business_Law = $studentResultRaw['Business_Law'];
$Business_LawRes = resultCalculate($Business_Law);

$Research_Method = $studentResultRaw['Research_Method'];
$Research_MethodRes = resultCalculate($Research_Method);

$Insur_Risk_Manag = $studentResultRaw['Insur_Risk_Manag'];
$Insur_Risk_ManagRes = resultCalculate($Insur_Risk_Manag);

$Inter_Busi = $studentResultRaw['Inter_Busi'];
$Inter_BusiRes = resultCalculate($Inter_Busi);

$OStrat_Mana = $studentResultRaw['OStrat_Mana'];
$OStrat_ManaRes = resultCalculate($OStrat_Mana);

$Opera_Manag = $studentResultRaw['Opera_ Manag'];
$Opera_ManagRes = resultCalculate($Opera_Manag);

$Strategic_Marketing = $studentResultRaw['Strategic_Marketing'];
$Strategic_MarketingRes = resultCalculate($Strategic_Marketing);

$Brand_Management = $studentResultRaw['Brand_Management'];
$Brand_ManagementRes = resultCalculate($Brand_Management);

$SupplChain_Manage = $studentResultRaw['SupplChain_Manage'];
$SupplChain_ManageRes = resultCalculate($SupplChain_Manage);

$HumResou_Plan = $studentResultRaw['HumResou_Plan'];
$HumResou_PlanRes = resultCalculate($HumResou_Plan);

$StratHumanResManag = $studentResultRaw['StratHumanResManag'];
$StratHumanResManagRes = resultCalculate($StratHumanResManag);

$HumResoInforSyst = $studentResultRaw['HumResoInforSyst'];
$HumResoInforSystRes = resultCalculate($HumResoInforSyst);





 
?>
<!DOCTYPE html>
<html lang="bn">
<head>
  <meta charset="UTF-8">
  <title>Academic Transcript</title>
  <style>
    body { font-family: Arial, sans-serif; margin: 0; padding: 0; }
    .container { width: 100%; max-width: 750px; margin: 0 auto; padding: 16px; }
    .header-table { width: 100%; table-layout: fixed; }
    .header-table td { vertical-align: middle; text-align: center; }
    .header-table .logo { width: 20%; text-align: left; }
    .header-table .title { width: 60%; padding: 0 10px; }
    .header-table .qr { width: 20%; text-align: right; }
    .text-sm { font-size: 14px; font-weight: 600; color: #374151; }
    .text-lg { font-size: 18px; font-weight: bold; }
    .text-xs { font-size: 12px; }
    .border { border: 1px solid #d1d5db; border-collapse: collapse; }
    .border td, .border th { border: 1px solid #d1d5db; padding: 4px; }
    .mt-20 { margin-top: 80px; }
    .mt-3 { margin-top: 12px; }
    .mb-4 { margin-bottom: 16px; }
    .year-results-block { margin-top: 1rem; }
    .year-results-block h2 { text-align: center; font-weight: 700; font-size: 1rem; margin: 0; color: #111827; }
    .year-table-wrapper { border: 1px solid #d1d5db; }
    .custom-table { width: 100%; border-collapse: collapse; font-size: 0.75rem; }
    .custom-table td, .custom-table th { padding: 1px 2px; color: #000000; font-weight: 500; }
    .year-table thead tr { border-bottom: 1px solid #d1d5db; }
    .year-table th { border-right: 1px solid #d1d5db; text-align: center; font-weight: 600; padding: 5px 3px; }
    .year-table th:last-child { border-right: none; }
    .year-table tbody tr.bordered-row td { border-bottom: 1px solid #d1d5db; }
    .year-table tbody td { border-right: 1px solid #d1d5db; text-align: center; }
    .year-table tbody td:last-child { border-right: none; }
    .subject-name-cell { padding-left: 0.5rem; text-align: left; }
    
    h1, p {
  margin: 0;
  padding: 0;
  line-height: 1.2;
}

.year-table tbody td.subject-name-cell {
  text-align: left !important;
}


  </style>
</head>
<body>
<div class="container">
  <table class="header-table">
    <tr>
      <td class="logo">
        <img src="https://result.bouedu.org/images_doc/gray-logo.png" alt="Logo" width="80">
      </td>
      <td class="title">
        <h1 class="text-lg">Bangladesh Open University</h1>
        <p class="text-sm">Bachelor of Business Administration (BBA)</p>
        <p class="text-sm">ACADEMIC RECORD (Online Version)</p>
      </td>
      <td class="qr">
        <img src="<?= $qrBase64 ?>" width="80" height="80" alt="QR Code">
      </td>
    </tr>
  </table>

  <div class="mt-3 mb-4" style="border-top: 1px solid #ccc;"></div>

  <table class="border text-xs" width="100%">
    <tr><td width="30%">Student ID:</td><td><?= $studentData['student_id'];?></td></tr>
    <tr><td>Student Name:</td><td><?= $studentData['name'];?></td></tr>
    <tr><td>Father's Name:</td><td><?= $studentData['father_name'];?></td></tr>
    <tr><td>Mother's Name:</td><td><?= $studentData['mother_name'];?></td></tr>
    <tr><td>Date of Birth:</td><td><?= $studentData['birth'];?></td></tr>
    <tr><td>Academic Year/Batch:</td><td><?= $studentData['batch'];?></td></tr>
    <tr><td>Passing Year:</td><td><?= $passingYear;?></td></tr>
    <tr><td>Result:</td><td><?= $studentResultRaw['gpa'];?></td></tr>
    <tr><td>Study Center:</td><td><?=  $studentData['study_centre_name'];?></td></tr>
  </table>

  <div class="year-results-block">
    <h2>1st Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course CODE</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
          <tr class="bordered-row"><td><?php echo $fstYear; ?></td><td>OSBBA 1101</td><td class="subject-name-cell">Introduction to Business</td><td><?php echo $Intro_BusinessRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $fstYear; ?></td><td>OSBBA 1102</td><td class="subject-name-cell">General English</td><td><?php echo $GEnglishRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $fstYear; ?></td><td>OSBBA 1103</td><td class="subject-name-cell">Basic Computer Studie</td><td><?php echo $Busi_Comp_StudieRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $fstYear; ?></td><td>OSBBA 1104</td><td class="subject-name-cell">Principles of Accounting</td><td><?php echo $Princ_AccountRes['grade_point']; ?></td></tr>
          
          
          
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="year-results-block">
    <h2>2nd Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $fstYear;?></td><td>OSBBA 1201</td><td class="subject-name-cell">Management: Theory and Practice</td><td><?php echo $ManagTheo_PracRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $fstYear;?></td><td>OSBBA 1202</td><td class="subject-name-cell">Bangladesh Studies</td><td><?php echo $bd_studyRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $fstYear;?></td><td>OSBBA 1203</td><td class="subject-name-cell">Mathematics for Managerial Decisions</td><td><?php echo $Math_ManagDecRes['grade_point']; ?></td></tr>
          
         
          <tr class="bordered-row"><td><?php echo $fstYear;?></td><td>OSBBA 1204</td><td class="subject-name-cell">Bank Management</td><td><?php echo $Bank_ManagementRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $fstYear;?></td><td>OSBBA 1205</td><td class="subject-name-cell">Principles of Marketing</td><td><?php echo $Prin_MarkRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="year-results-block">
    <h2>3rd Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2301</td><td class="subject-name-cell">Advanced Accounting</td><td><?php echo $Advan_AccountRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2302</td><td class="subject-name-cell">Financial Management</td><td><?php echo $Fina_ManagRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2303</td><td class="subject-name-cell">Microeconomics</td><td><?php echo $MicroeconomicsRes['grade_point']; ?></td></tr>
          
         
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2304</td><td class="subject-name-cell">Business Statistics</td><td><?php echo $Business_StatisticsRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>	OSBBA 2305</td><td class="subject-name-cell">Environmental Science</td><td><?php echo $Environmental_ScienceRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="year-results-block">
    <h2>4th Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2401</td><td class="subject-name-cell">Industrial Pshychology</td><td><?php echo $Indus_PshyRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2402</td><td class="subject-name-cell">Business Communication</td><td><?php echo $Busi_CommuniRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2403</td><td class="subject-name-cell">Taxation and Auditing</td><td><?php echo $Taxa_AudRes['grade_point']; ?></td></tr>
          
         
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>OSBBA 2404</td><td class="subject-name-cell">Human Resource Management</td><td><?php echo $Human_Res_ManagRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $secYear;?></td><td>	OSBBA 2405</td><td class="subject-name-cell">Marketing Management</td><td><?php echo $M_ManagementRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="year-results-block">
    <h2>5th Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3501</td><td class="subject-name-cell">Entrepreneurship Development</td><td><?php echo $Entrep_DevelopRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3502</td><td class="subject-name-cell">Macroeconomics</td><td><?php echo $MacroeconomicsRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3503</td><td class="subject-name-cell">Management Information Systems</td><td><?php echo $Manage_Info_SystRes['grade_point']; ?></td></tr> 
          
         
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3504</td><td class="subject-name-cell">E-Commerce</td><td><?php echo $E_CommerceRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>	OSBBA 3505</td><td class="subject-name-cell">Marketing Promotion</td><td><?php echo $Mark_PromRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  
  <div class="year-results-block">
    <h2>6th Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3601</td><td class="subject-name-cell">Industrial Relation</td><td><?php echo $indus_RelationRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3602</td><td class="subject-name-cell">Cost and Management Accounting</td><td><?php echo $Cost_Mana_AccountRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 2603</td><td class="subject-name-cell">Total Quality Management</td><td><?php echo $Total_Qual_ManageRes['grade_point']; ?></td></tr> 
          
         
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>OSBBA 3604</td><td class="subject-name-cell">Organizational Behavior</td><td><?php echo $org_BehaviorRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $thirtYear;?></td><td>	OSBBA 3605</td><td class="subject-name-cell">Business Law</td><td><?php echo $Business_LawRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  <div class="year-results-block">
    <h2>7th Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA 4701</td><td class="subject-name-cell">Research Method</td><td><?php echo $Research_MethodRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA 4702</td><td class="subject-name-cell">Insurance and Risk Management</td><td><?php echo $Insur_Risk_ManagRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA 4703</td><td class="subject-name-cell">International Business</td><td><?php echo $Inter_BusiRes['grade_point']; ?></td></tr> 
          
         
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA 4704</td><td class="subject-name-cell">OStrategic Management</td><td><?php echo $OStrat_ManaRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>	OSBBA 4705</td><td class="subject-name-cell">Operations Management</td><td><?php echo $Opera_ManagRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>
  
  
  <div class="year-results-block">
    <h2>8th Semester</h2>
    <div class="year-table-wrapper">
      <table class="custom-table year-table">
        <thead>
          <tr>
            <th class="th-exam-year">Exam Year/Term</th>
            <th class="th-subject-code">Subject/Course Code</th>
            <th class="th-subject-name">Subject/Course Name</th>
            <th class="th-letter-grade">Letter Grade</th>
          </tr>
        </thead>
        <tbody>
            <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA MKT–4807</td><td class="subject-name-cell">Strategic Marketing</td><td><?php echo $Strategic_MarketingRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA MKT-4808</td><td class="subject-name-cell">Brand Management</td><td><?php echo $Brand_ManagementRes['grade_point']; ?></td></tr>
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA 4809</td><td class="subject-name-cell">Supply Chain Management</td><td><?php echo $SupplChain_ManageRes['grade_point']; ?></td></tr> 
          
         
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>OSBBA-HRM 4812</td><td class="subject-name-cell">Human Resource Planning</td><td><?php echo $HumResou_PlanRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>	OSBBA-HRM 4813</td><td class="subject-name-cell">Strategic Human Resource Management</td><td><?php echo $StratHumanResManagRes['grade_point']; ?></td></tr>
          
          <tr class="bordered-row"><td><?php echo $passingYear;?></td><td>	OSBBA-HRM 4814</td><td class="subject-name-cell">Human Resource Information System</td><td><?php echo $HumResoInforSystRes['grade_point']; ?></td></tr>
          
          
          
        </tbody>
      </table>
    </div>
  </div>

  <div class="mt-3 text-xs border" style="padding: 6px;">
    <p><strong>Note 1:</strong> (-) - Waiver AB - Absent, PR - Problem Related to OMR Sheet fill-up, RP - Expelled in the respective course, WH - Withheld, IC - Incomplete, NA - Not Applicable, X - No Grade Received.</p>
    <p><strong>Note 2:</strong> This report is system generated. No signature required.</p>
  </div>

  <div class="mt-20" style="border-top: 1px solid #ccc;"></div>
  <p class="text-xs text-center" style="margin-top: 4px;">
    All Rights Reserved by BOU. Developed & Maintained by ICT Unit, BOU
  </p>
</div>
</body>
</html>
<?php
$html = ob_get_clean();
$dompdf = new Dompdf();
$dompdf->set_option('isRemoteEnabled', true);
$dompdf->loadHtml($html);
$dompdf->setPaper('A4', 'portrait');
$dompdf->render();
$dompdf->stream("Academic Transcript.pdf", ["Attachment" => false]);
exit;
?>
